import axios from 'axios'

// Google Analytics 4 Measurement ID (G-XXXXXXXXXX)
const measurementId = 'G-MPCN0S35NM' // Replace with your GA4 Measurement ID

// Google Analytics 4 API Secret (generated in GA4 console)
const apiSecret = 'EasU2ZBSSqmTmm06asIVAg' // Replace with your API secret

const locationData = {
    country: 'USA',
    region: 'California',
    city: 'Los Angeles',
}

// Function to send pageview event to GA4
async function sendPageViewToGA4(pageUrl, locationData) {
    const payload = {
        client_id: '555', // Client ID (can be a random string or user identifier)
        events: [
            {
                name: 'page_view', // Event name (for page view)
                params: {
                    page_location: `https://webmitr.in${pageUrl}`, // Full URL
                    page_title: 'Nishant', // Title of the page
                    country: locationData.country,
                    region: locationData.region,
                    city: locationData.city,
                },
            },
        ],
    }

    try {
        const response = await axios.post(
            `https://www.google-analytics.com/mp/collect?measurement_id=${measurementId}&api_secret=${apiSecret}`,
            payload,
        )
        console.log('Pageview sent successfully to GA4', response.status)
    } catch (error) {
        console.error('Error sending pageview to GA4:', error)
    }
}

// Example usage
for (let i = 1; i <= 5; i++) {
    sendPageViewToGA4(`/about`, locationData)
}
