import useSWR from 'swr'
import axios from '@/lib/axios'

export const usePost = () => {
    const { data: posts, error } = useSWR('/api/posts', () =>
        axios
            .get('/api/posts')
            .then(res => res.data)
            .catch(error => {
                if (error.response.status !== 409) throw error
            }),
    )

    return {
        posts,
        error,
    }
}
