'use client'

import { useEffect } from 'react'

export default function Webpushr() {
    useEffect(() => {
        if (typeof window.webpushr !== 'undefined') return

        window.webpushr =
            window.webpushr ||
            function () {
                ;(window.webpushr.q = window.webpushr.q || []).push(arguments)
            }

        const setupWebpushr = () => {
            const js = document.createElement('script')

            const fjs = document.getElementsByTagName('script')[0]

            js.id = 'webpushr-jssdk'

            js.async = 1

            js.src = 'https://cdn.webpushr.com/app.min.js'

            fjs.parentNode.appendChild(js)

            window.webpushr('setup', {
                key: process.env.WEBPUSHR_KEY,

                integration: 'popup',
            })
        }

        setupWebpushr()
    }, [])

    return null
}
