import { fetchVideos } from '@/actions/fetchPost'
import React from 'react'
import VideoThumbnail from './VideoThumbnail'
import Link from 'next/link'

const revalidate = 300

async function Videos() {
    const videos = await fetchVideos()

    return (
        <div className="flex gap-4 w-full overflow-x-scroll no-scrollbar snap-mandatory snap-x">
            {videos &&
                videos.data.map(video => (
                    <Link
                        href={`/video/${video.slug}`}
                        key={video.id}
                        className="snap-start">
                        <VideoThumbnail src={video.thumbnail} />
                        <p className="line-clamp-2 pt-1">{video.title}</p>
                    </Link>
                ))}
        </div>
    )
}

export default Videos
