// components/VideoThumbnail.js
import Image from 'next/image'

const VideoThumbnail = ({ src }) => {
    return (
        <div className="relative w-72 h-40 overflow-hidden rounded-lg shadow-lg">
            <Image
                src={src}
                alt={'video thumbnail'}
                fill
                sizes="(max-width: 640px) 100vw, 300px"
                className="object-cover"
            />
        </div>
    )
}

export default VideoThumbnail
