'use client' // Ensures the component runs on the client side

import { useState } from 'react'

const TextToSpeech = ({ htmlContent }) => {
    const [isSpeaking, setIsSpeaking] = useState(false)

    const speakContent = () => {
        if (typeof window === 'undefined' || !window.speechSynthesis) {
            alert('Text-to-Speech is not supported in this browser.')
            return
        }

        // Extract text content from HTML
        const div = document.createElement('div')
        div.innerHTML = htmlContent
        const text = div.textContent || div.innerText || ''

        if (!text.trim()) {
            alert('No text to read.')
            return
        }

        const utterance = new SpeechSynthesisUtterance(text)
        utterance.lang = 'hi-IN' // Adjust language as needed (e.g., "hi-IN" for Hindi)
        utterance.pitch = 1 // Normal pitch
        utterance.rate = 1 // Normal speed
        utterance.volume = 1 // volume

        utterance.onstart = () => setIsSpeaking(true)
        utterance.onend = () => setIsSpeaking(false)
        utterance.onerror = err => {
            setIsSpeaking(false)
        }

        speechSynthesis.cancel() // Clear any ongoing speech
        speechSynthesis.speak(utterance)
    }

    const stopSpeaking = () => {
        window.speechSynthesis.cancel()
        setIsSpeaking(false)
    }

    return (
        <div className="w-full">
            <button
                className="w-full px-2 py-1 bg-red-600 text-white my-2 rounded text-lg transition-all duration-500 hover:bg-red-700"
                onClick={isSpeaking ? stopSpeaking : speakContent}>
                {isSpeaking ? 'Stop' : 'न्यूज़ सुने'}
            </button>
        </div>
    )
}

export default TextToSpeech
