import React from 'react'

import {
    Sheet,
    SheetClose,
    SheetContent,
    SheetDescription,
    SheetHeader,
    SheetTitle,
    SheetTrigger,
} from '@/components/ui/sheet'

import Link from 'next/link'
import { fetchMenu } from '@/actions/fetch-settings'

async function SideMenu() {
    const menus = await fetchMenu()

    return (
        <Sheet>
            <SheetTrigger>
                <div className="flex flex-col whitespace-nowrap gap-1">
                    <svg
                        id="MENU_DEFAULT"
                        xmlns="http://www.w3.org/2000/svg"
                        width="22"
                        height="22"
                        viewBox="0 0 22 22">
                        {' '}
                        <g
                            id="Rectangle_9787"
                            data-name="Rectangle 9787"
                            fill="none"
                            stroke="#333"
                            strokeWidth="1.5">
                            {' '}
                            <rect
                                width="10"
                                height="10"
                                rx="2"
                                stroke="none"></rect>{' '}
                            <rect
                                x="0.75"
                                y="0.75"
                                width="8.5"
                                height="8.5"
                                rx="1.25"
                                fill="none"></rect>{' '}
                        </g>{' '}
                        <g
                            id="Rectangle_9789"
                            data-name="Rectangle 9789"
                            transform="translate(0 12)"
                            fill="none"
                            stroke="#333"
                            strokeWidth="1.5">
                            {' '}
                            <rect
                                width="10"
                                height="10"
                                rx="2"
                                stroke="none"></rect>{' '}
                            <rect
                                x="0.75"
                                y="0.75"
                                width="8.5"
                                height="8.5"
                                rx="1.25"
                                fill="none"></rect>{' '}
                        </g>{' '}
                        <g
                            id="Rectangle_9788"
                            data-name="Rectangle 9788"
                            transform="translate(12)"
                            fill="none"
                            stroke="#333"
                            strokeWidth="1.5">
                            {' '}
                            <rect
                                width="10"
                                height="10"
                                rx="2"
                                stroke="none"></rect>{' '}
                            <rect
                                x="0.75"
                                y="0.75"
                                width="8.5"
                                height="8.5"
                                rx="1.25"
                                fill="none"></rect>{' '}
                        </g>{' '}
                        <g
                            id="Rectangle_9790"
                            data-name="Rectangle 9790"
                            transform="translate(12 12)"
                            fill="#333"
                            stroke="#333"
                            strokeWidth="1.5">
                            {' '}
                            <rect
                                width="10"
                                height="10"
                                rx="2"
                                stroke="none"></rect>{' '}
                            <rect
                                x="0.75"
                                y="0.75"
                                width="8.5"
                                height="8.5"
                                rx="1.25"
                                fill="none"></rect>{' '}
                        </g>{' '}
                    </svg>
                    मेनू
                </div>
            </SheetTrigger>
            <SheetContent side="left">
                <SheetHeader>
                    <SheetTitle>जनपद न्यूज़ टाइम्स</SheetTitle>
                    <SheetDescription>
                        आपके शहर की खबर प्राप्त करें
                    </SheetDescription>
                </SheetHeader>
                <div>
                    <Link href="/" className="text-white">
                        होम
                    </Link>
                    <div className="flex flex-col text-black font-bold gap-2 text-lg">
                        {menus?.data?.map((menu, index) => (
                            <SheetClose key={index} asChild>
                                <Link
                                    href={menu.url ?? `/${menu.linkable.slug}`}
                                    className="">
                                    {menu.title}
                                </Link>
                            </SheetClose>
                        ))}
                    </div>
                </div>
            </SheetContent>
        </Sheet>
    )
}

export default SideMenu
