import React from 'react'
import {
    Command,
    CommandEmpty,
    CommandInput,
    CommandItem,
    CommandList,
} from '@/components/ui/command'
import {
    Sheet,
    SheetClose,
    SheetContent,
    SheetDescription,
    SheetHeader,
    SheetTitle,
    SheetTrigger,
} from '@/components/ui/sheet'
import { MapPin } from 'lucide-react'
import { fetchCategoryList } from '@/actions/fetchPost'
import Link from 'next/link'

async function SideBar() {
    const categoryList = await fetchCategoryList('uttarpradesh')

    return (
        <Sheet>
            <SheetTrigger>
                <div className="flex whitespace-nowrap gap-1">
                    <MapPin color="red" size={20} /> अपना शहर
                </div>
            </SheetTrigger>
            <SheetContent>
                <SheetHeader>
                    <SheetTitle>अपना शहर चुनें</SheetTitle>
                    <SheetDescription>
                        आपके शहर की खबर प्राप्त करें
                    </SheetDescription>
                </SheetHeader>

                <Command className="mt-2  ">
                    <CommandInput placeholder="खोज करें..." />
                    <CommandList className="min-h-full">
                        <CommandEmpty>No results found.</CommandEmpty>
                        {categoryList?.categoryWithChildren &&
                            categoryList?.categoryWithChildren.map(category => (
                                <CommandItem
                                    className="cursor-pointer mb-2 first:mt-2"
                                    key={category.id}>
                                    <Link href={`/${category.slug}`}>
                                        <SheetClose asChild>
                                            <span className="font-bold">
                                                {category.name}
                                                <span className="hidden">
                                                    {category.slug}
                                                </span>
                                            </span>
                                        </SheetClose>
                                    </Link>
                                </CommandItem>
                            ))}
                        {/* <CommandItem>Profile</CommandItem> */}
                    </CommandList>
                </Command>
            </SheetContent>
        </Sheet>
    )
}

export default SideBar
