'use client'
import React from 'react'
import {
    FacebookShareButton,
    FacebookIcon,
    WhatsappShareButton,
    WhatsappIcon,
    TwitterShareButton,
    XIcon,
    TelegramShareButton,
    TelegramIcon,
} from 'react-share'

function Sharer({ shareUrl }) {
    return (
        <div className="flex gap-2 items-center">
            <FacebookShareButton name="facebook" url={shareUrl}>
                <FacebookIcon size={40} round />
            </FacebookShareButton>
            <WhatsappShareButton name="whatsapp" url={shareUrl}>
                <WhatsappIcon size={40} round />
            </WhatsappShareButton>
            <TwitterShareButton name="twitter" url={shareUrl}>
                <XIcon size={40} round />
            </TwitterShareButton>
            <TelegramShareButton name="telegram" url={shareUrl}>
                <TelegramIcon size={40} round />
            </TelegramShareButton>
        </div>
    )
}

export default Sharer
