import React from 'react'
// import { APP_URL } from '@/constant/apiEndpoints'
import { format } from 'date-fns'
import Image from 'next/image'
import Link from 'next/link'

function PostBlock({ post }) {
    return (
        <Link className="" href={`/news/${post.slug}`}>
            <div className="flex gap-2 p-2 border rounded shadow w-full hover:scale-[102%] transition-all duration-100 bg-white">
                <div className="w-full max-w-32">
                    {post.featured_image ? (
                        <Image
                            width={500}
                            height={500}
                            src={post.featured_image}
                            className='"w-32 min-w-32 aspect-video rounded object-cover'
                            alt="Featured Image"
                            loading="lazy"
                        />
                    ) : (
                        <Image
                            width={500}
                            height={500}
                            src={'/janpad-placeholder.png'}
                            className='"w-32 min-w-32 aspect-video rounded object-cover'
                            alt="Featured Image"
                            loading="lazy"
                        />
                    )}
                </div>
                <div>
                    <h2 className=" font-semibold line-clamp-2">
                        {post.sub_title && (
                            <span className={`text-red-600`}>
                                {post.sub_title} :
                            </span>
                        )}
                        {post.title}
                    </h2>
                    <div className="flex -ml-1">
                        <span>
                            {post?.location_name && (
                                <div className="flex gap-1 text-sm items-center p-0.5 text-white rounded-full px-2 bg-red-600">
                                    <span>
                                        <svg
                                            xmlns="http://www.w3.org/2000/svg"
                                            fill="none"
                                            viewBox="0 0 24 24"
                                            strokeWidth="1.5"
                                            stroke="currentColor"
                                            className="size-4 ">
                                            <path
                                                strokeLinecap="round"
                                                strokeLinejoin="round"
                                                d="M15 10.5a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z"
                                            />
                                            <path
                                                strokeLinecap="round"
                                                strokeLinejoin="round"
                                                d="M19.5 10.5c0 7.142-7.5 11.25-7.5 11.25S4.5 17.642 4.5 10.5a7.5 7.5 0 1 1 15 0Z"
                                            />
                                        </svg>
                                    </span>
                                    <span className="text-xs font-bold">
                                        {post?.location_name}
                                    </span>
                                </div>
                            )}
                        </span>
                    </div>
                    <p className="text-sm">
                        {post.updated_at
                            ? format(
                                  post.updated_at,
                                  "dd MMM yyyy 'at' HH:mm a",
                              )
                            : format(
                                  post.created_at,
                                  "eeee, dd MMM yyyy 'at' HH:mm a",
                              )}
                    </p>
                </div>
            </div>
        </Link>
    )
}

export default PostBlock
