'use client'

import React from 'react'
import { Swiper, SwiperSlide } from 'swiper/react'
import { Autoplay, EffectFade } from 'swiper/modules'
import { APP_URL_STORAGE } from '@/constant/apiEndpoints'

function HomeSlider({ slides }) {
    return (
        <Swiper
            spaceBetween={50}
            slidesPerView={1}
            // onSlideChange={() => console.log('slide change')}
            loop={true}
            autoplay={{
                delay: 5000,
                pauseOnMouseEnter: true,
            }}
            modules={[Autoplay]}
            // onSwiper={swiper => console.log(swiper)}
        >
            {slides.map((slide, index) => (
                <SwiperSlide key={index}>
                    <img
                        className="h-full w-full object-cover"
                        src={`${APP_URL_STORAGE}/${slide}`}
                        alt="image"
                    />
                </SwiperSlide>
            ))}
        </Swiper>
    )
}

export default HomeSlider
