import Image from 'next/image'
import Link from 'next/link'

import SideBar from './SideBar'
import { fetchBrand, fetchMenu } from '@/actions/fetch-settings'

import SideMenu from './SideMenu'
import { APP_URL_STORAGE } from '@/constant/apiEndpoints'

import LiveClock from './LiveClock'

export const revalidate = 300

async function Header() {
    const menus = await fetchMenu()
    const brand = await fetchBrand()

    return (
        <header className=" w-full  flex flex-col justify-between items-center bg-white  ">
            <div className="w-full border-b flex justify-between sm:px-2 py-1">
                <LiveClock />
                <div>
                    <a
                        target="_blank"
                        className="bg-red-600 text-white py-1 px-2 rounded text-sm"
                        href="https://apply.janpadnewstimes.com/users-apply-form.php">
                        <span>Become Reporter</span>
                    </a>
                </div>
            </div>
            <div className="flex px-2 sm:px-40 justify-between items-center w-full">
                <Link href="/">
                    <Image
                        width={200}
                        height={70}
                        src={APP_URL_STORAGE + '/' + brand?.brand_logo}
                        alt="logo"
                        className="max-w-[200px] max-h-[100px]"
                    />
                </Link>
                {/* sidebar */}
                <SideBar />
            </div>

            <div className=" bg-[#000068] py-2 px-2 sm:px-40 w-full ">
                <div className=" bg-[#000068]  w-full flex whitespace-nowrap gap-3 overflow-x-scroll font-bold no-scrollbar">
                    {menus?.data?.map((menu, index) => (
                        <Link
                            key={menu.id}
                            href={menu?.url ?? `/${menu?.linkable.slug}`}
                            className="text-white">
                            {menu?.title}
                        </Link>
                    ))}
                </div>
            </div>

            <div className="fixed z-[99] border-t bottom-0 flex items-center justify-between w-full gap-2 p-2 px-8 mt-8 bg-white lg:hidden h-18 ">
                <Link
                    href="/"
                    className="flex flex-col items-center justify-center ">
                    <svg
                        xmlns="http://www.w3.org/2000/svg"
                        fill="none"
                        viewBox="0 0 24 24"
                        strokeWidth={1.5}
                        stroke="currentColor"
                        className="w-6 h-6">
                        <path
                            strokeLinecap="round"
                            strokeLinejoin="round"
                            d="M2.25 12l8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25"
                        />
                    </svg>
                    होम
                </Link>
                <Link
                    href="/top-news"
                    className="flex flex-col items-center justify-center ">
                    <svg
                        xmlns="http://www.w3.org/2000/svg"
                        fill="none"
                        viewBox="0 0 24 24"
                        strokeWidth={1.5}
                        stroke="currentColor"
                        className="w-6 h-6">
                        <path
                            strokeLinecap="round"
                            d="M15.75 10.5l4.72-4.72a.75.75 0 011.28.53v11.38a.75.75 0 01-1.28.53l-4.72-4.72M4.5 18.75h9a2.25 2.25 0 002.25-2.25v-9a2.25 2.25 0 00-2.25-2.25h-9A2.25 2.25 0 002.25 7.5v9a2.25 2.25 0 002.25 2.25z"
                        />
                    </svg>
                    बड़ी ख़बरें
                </Link>
                <Link
                    href="/videos"
                    className="flex flex-col items-center justify-center ">
                    <svg
                        xmlns="http://www.w3.org/2000/svg"
                        fill="none"
                        viewBox="0 0 24 24"
                        strokeWidth={1.5}
                        stroke="currentColor"
                        className="w-6 h-6">
                        <path
                            strokeLinecap="round"
                            strokeLinejoin="round"
                            d="M3.375 19.5h17.25m-17.25 0a1.125 1.125 0 01-1.125-1.125M3.375 19.5h1.5C5.496 19.5 6 18.996 6 18.375m-3.75 0V5.625m0 12.75v-1.5c0-.621.504-1.125 1.125-1.125m18.375 2.625V5.625m0 12.75c0 .621-.504 1.125-1.125 1.125m1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125m0 3.75h-1.5A1.125 1.125 0 0118 18.375M20.625 4.5H3.375m17.25 0c.621 0 1.125.504 1.125 1.125M20.625 4.5h-1.5C18.504 4.5 18 5.004 18 5.625m3.75 0v1.5c0 .621-.504 1.125-1.125 1.125M3.375 4.5c-.621 0-1.125.504-1.125 1.125M3.375 4.5h1.5C5.496 4.5 6 5.004 6 5.625m-3.75 0v1.5c0 .621.504 1.125 1.125 1.125m0 0h1.5m-1.5 0c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125m1.5-3.75C5.496 8.25 6 7.746 6 7.125v-1.5M4.875 8.25C5.496 8.25 6 8.754 6 9.375v1.5m0-5.25v5.25m0-5.25C6 5.004 6.504 4.5 7.125 4.5h9.75c.621 0 1.125.504 1.125 1.125m1.125 2.625h1.5m-1.5 0A1.125 1.125 0 0118 7.125v-1.5m1.125 2.625c-.621 0-1.125.504-1.125 1.125v1.5m2.625-2.625c.621 0 1.125.504 1.125 1.125v1.5c0 .621-.504 1.125-1.125 1.125M18 5.625v5.25M7.125 12h9.75m-9.75 0A1.125 1.125 0 016 10.875M7.125 12C6.504 12 6 12.504 6 13.125m0-2.25C6 11.496 5.496 12 4.875 12M18 10.875c0 .621-.504 1.125-1.125 1.125M18 10.875c0 .621.504 1.125 1.125 1.125m-2.25 0c.621 0 1.125.504 1.125 1.125m-12 5.25v-5.25m0 5.25c0 .621.504 1.125 1.125 1.125h9.75c.621 0 1.125-.504 1.125-1.125m-12 0v-1.5c0-.621-.504-1.125-1.125-1.125M18 18.375v-5.25m0 5.25v-1.5c0-.621.504-1.125 1.125-1.125M18 13.125v1.5c0 .621.504 1.125 1.125 1.125M18 13.125c0-.621.504-1.125 1.125-1.125M6 13.125v1.5c0 .621-.504 1.125-1.125 1.125M6 13.125C6 12.504 5.496 12 4.875 12m-1.5 0h1.5m-1.5 0c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125M19.125 12h1.5m0 0c.621 0 1.125.504 1.125 1.125v1.5c0 .621-.504 1.125-1.125 1.125m-17.25 0h1.5m14.25 0h1.5"
                        />
                    </svg>
                    विडियो
                </Link>
                <div className="">
                    <SideMenu />
                </div>
            </div>
        </header>
    )
}

export default Header
