import { fetchSocial } from '@/actions/fetch-settings'

import Image from 'next/image'
import Link from 'next/link'
import React from 'react'
import { FacebookIcon, TelegramIcon, XIcon } from 'react-share'

async function Footer() {
    const social = await fetchSocial()

    return (
        <footer className="w-full max-w-[85rem] py-10 px-4 sm:px-6 lg:px-8 mx-auto bg-black my-10 ">
            <div className="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-7 gap-6 mb-10 ">
                <div className="col-span-full hidden lg:col-span-2 lg:block">
                    <a
                        className="flex-none font-semibold text-xl text-white focus:outline-none focus:opacity-80"
                        href="#"
                        aria-label="Janpad News Times">
                        Janpad News Times
                    </a>
                    <Link href="/">
                        <Image
                            width={200}
                            height={150}
                            src="/janpad-news-times-logo.png"
                            alt="logo"
                        />
                    </Link>
                </div>

                <div>
                    <div className="grid space-y-3 text-sm sm:text-lg">
                        <p>
                            <Link
                                className="inline-flex font-bold border-b-2 w-20 gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/">
                                होम
                            </Link>
                        </p>
                        <div className="flex flex-col gap-2 text-sm">
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/top-news">
                                बड़ी खबर
                            </Link>
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/videos">
                                टॉप वीडियो
                            </Link>

                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/national">
                                देश
                            </Link>
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/international">
                                विदेश
                            </Link>
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/crime">
                                क्राइम
                            </Link>
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/sports">
                                खेल-कूद
                            </Link>
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/education">
                                शिक्षा
                            </Link>
                        </div>
                    </div>
                </div>
                <div>
                    <div className="grid space-y-3 text-sm sm:text-lg">
                        <p>
                            <Link
                                className="inline-flex font-bold border-b-2 w-20 gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="#">
                                राज्य
                            </Link>
                        </p>
                        <div className="flex flex-col gap-2 text-sm">
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/uttar-pradesh">
                                उत्तर प्रदेश
                            </Link>
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/uttrakhand">
                                उत्तराखंड
                            </Link>
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/madhya-pradesh">
                                मध्य प्रदेश
                            </Link>
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/chhatisgarh">
                                छतीसगढ़
                            </Link>
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/bihar">
                                बिहार
                            </Link>
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/jharkhand">
                                झारखण्ड
                            </Link>
                        </div>
                    </div>
                </div>
                <div>
                    <div className="grid space-y-3 text-sm sm:text-lg">
                        <p>
                            <Link
                                className="inline-flex whitespace-nowrap font-bold border-b-2 w-20 gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="#">
                                अपना जिला
                            </Link>
                        </p>
                        <div className="flex flex-col gap-2 text-sm">
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/chandoli">
                                चंदोली
                            </Link>
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/mirzapur">
                                मिर्ज़ापुर
                            </Link>
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/varanasi">
                                वाराणसी
                            </Link>
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/gazipur">
                                गाजीपुर
                            </Link>
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/shajahanpur">
                                शाहजहांपुर
                            </Link>
                            <Link
                                className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="/jharkhand">
                                झारखण्ड
                            </Link>
                        </div>
                    </div>
                </div>
                <div>
                    <div className="grid space-y-3 text-sm sm:text-lg">
                        <p>
                            <Link
                                className="inline-flex font-bold border-b-2 w-20 gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="#">
                                Policies
                            </Link>
                        </p>
                        <div className="flex flex-col gap-2 text-sm">
                            <p>
                                <Link
                                    className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                    href="/privacy-policy">
                                    Privacy Policy
                                </Link>
                            </p>
                            <p>
                                <Link
                                    className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                    href="/grievance-policy">
                                    Grievance Policy
                                </Link>
                            </p>
                        </div>
                    </div>
                </div>
                <div>
                    <div className="grid space-y-3 text-sm sm:text-lg">
                        <p>
                            <Link
                                className="inline-flex font-bold border-b-2 w-20 gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                href="#">
                                Internal
                            </Link>
                        </p>
                        <div className="flex flex-col gap-2 text-sm">
                            <p>
                                <a
                                    target="_blank"
                                    className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                    href="https://apply.janpadnewstimes.com/users-apply-form.php"
                                    rel="noreferrer">
                                    Become a Reporter
                                </a>
                            </p>
                            <p>
                                <a
                                    className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                    href="/admin">
                                    Backend Login
                                </a>
                            </p>
                            <p>
                                <a
                                    target="_blank"
                                    className="inline-flex gap-x-2 text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
                                    href="https://apply.janpadnewstimes.com/card-download.php"
                                    rel="noreferrer">
                                    Download Id Card
                                </a>{' '}
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <div className="pt-5 mt-5 border-t border-gray-200 ">
                <div className="sm:flex sm:flex-wrap sm:justify-between sm:items-center">
                    <div className="flex flex-wrap items-center gap-3">
                        <div className="space-x-4 text-sm">
                            <p className="mt-3 text-xs sm:text-sm text-white hidden sm:block">
                                © 2024 All Right Reserved. Janpad News Times |
                                Designed by Webmitr Digital Services Pvt Ltd
                            </p>
                        </div>
                    </div>
                    <div className="flex flex-wrap items-center gap-3">
                        <div className="mt-5 sm:mt-o space-y-2 text-sm">
                            <p className=" text-white">Mobile: 9415445270</p>
                            <p className="text-white">
                                Email: janpadnewstimes@gmail.com,
                            </p>
                            <p className="text-white">
                                Head Office : Dhanapur Chandauli U.P. Pin 232105
                            </p>
                        </div>
                    </div>

                    <div className="flex flex-wrap justify-between items-center gap-3">
                        <div className="mt-3 sm:hidden">
                            <a
                                className="flex-none font-semibold text-xl text-white focus:outline-none focus:opacity-80"
                                href="#"
                                aria-label="Janpad News Times">
                                Janpad News Times
                            </a>
                            <p className="mt-1 text-xs sm:text-sm text-white">
                                © 2024-2025 Janpad News Times
                            </p>
                        </div>
                        <div className="flex gap-2">
                            {social.facebook && (
                                <Link target="_blank" href={social?.facebook}>
                                    <FacebookIcon
                                        className="rounded"
                                        size={30}
                                    />
                                </Link>
                            )}
                            {social.twitter && (
                                <Link target="_blank" href={social?.twitter}>
                                    <XIcon
                                        className="border rounded"
                                        size={30}
                                    />
                                </Link>
                            )}
                            {social.telegram && (
                                <Link target="_blank" href={social?.telegram}>
                                    <TelegramIcon
                                        className="rounded"
                                        size={30}
                                    />
                                </Link>
                            )}
                            {social.youtube && (
                                <Link target="_blank" href={social?.youtube}>
                                    <svg
                                        xmlns="http://www.w3.org/2000/svg"
                                        x="0px"
                                        y="0px"
                                        width="35"
                                        height="35"
                                        viewBox="0 0 48 48">
                                        <path
                                            fill="#FF3D00"
                                            d="M43.2,33.9c-0.4,2.1-2.1,3.7-4.2,4c-3.3,0.5-8.8,1.1-15,1.1c-6.1,0-11.6-0.6-15-1.1c-2.1-0.3-3.8-1.9-4.2-4C4.4,31.6,4,28.2,4,24c0-4.2,0.4-7.6,0.8-9.9c0.4-2.1,2.1-3.7,4.2-4C12.3,9.6,17.8,9,24,9c6.2,0,11.6,0.6,15,1.1c2.1,0.3,3.8,1.9,4.2,4c0.4,2.3,0.9,5.7,0.9,9.9C44,28.2,43.6,31.6,43.2,33.9z"></path>
                                        <path
                                            fill="#FFF"
                                            d="M20 31L20 17 32 24z"></path>
                                    </svg>
                                </Link>
                            )}
                        </div>
                    </div>
                </div>
            </div>
        </footer>
    )
}

export default Footer
