import Image from 'next/image'
import Link from 'next/link'
import React from 'react'

function BigPostBlock({ post }) {
    return (
        <Link
            href={`/news/${post.slug}`}
            key={post.id}
            className="lg:row-span-3 mt-2 rounded relative hover:scale-[102%] transition-all duration-100 w-full ">
            <div className="w-full h-full object-cover">
                {/* <Image
                    width={500}
                    height={600}
                    src={post.featured_image}
                    alt="Featured Image"
                    className="object-cover h-full w-full"
                /> */}
                {post.featured_image ? (
                    <Image
                        width={500}
                        height={500}
                        src={post.featured_image}
                        className='"object-cover h-full w-full aspect-video'
                        alt="Featured Image"
                        loading="lazy"
                    />
                ) : (
                    <Image
                        width={500}
                        height={500}
                        src={'/janpad-placeholder.png'}
                        className='"object-cover h-full w-full'
                        alt="Featured Image"
                    />
                )}
            </div>
            <div className="absolute min-w-full flex items-end bottom-0 left-0 bg-gradient-to-t from-black to-transparent via-transparent via-50% h-40">
                <p className="text-white p-2 line-clamp-3 font-bold ">
                    {post.title}
                </p>
            </div>
        </Link>
    )
}

export default BigPostBlock
