import { fetchAds, fetchPosts } from '@/actions/fetchPost'
import React from 'react'
import Marquee from 'react-fast-marquee'

export const revalidate = 300

async function AdHeader() {
    const ads = await fetchAds()

    const posts = await fetchPosts()
    return (
        <>
            <div className=" px-2 sm:px-6 bg-red-600 gap-2 w-full py-1 items-center flex sm:fixed bottom-0 z-[99] ">
                <p className="text-white font-bold">Advertisment</p>
                <div className="px-2 py-1 bg-white rounded-full overflow-hidden w-full">
                    <Marquee>
                        {ads?.scrollText?.map((item, index) => (
                            <p className="mr-4" key={index}>
                                {item?.advertisement?.scrollTextLine}
                            </p>
                        ))}
                    </Marquee>
                </div>
            </div>

            <div className=" px-2 sm:px-6 bg-[#000068] flex gap-2 w-full py-1 items-center border-t ">
                <p className="text-white font-bold whitespace-nowrap">
                    ब्रेकिंग न्यूज़
                </p>
                <div className="px-2 py-1 bg-white rounded-full overflow-hidden w-full">
                    <Marquee>
                        {posts?.data?.map((item, index) => (
                            <p className="mr-4" key={index}>
                                {item?.title}
                            </p>
                        ))}
                    </Marquee>
                </div>
            </div>
        </>
    )
}

export default AdHeader
