import { fetchVideos } from '@/actions/fetchPost'
import {
    Pagination,
    PaginationContent,
    PaginationEllipsis,
    PaginationItem,
    PaginationLink,
} from '@/components/ui/pagination'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import Link from 'next/link'

const {
    default: MaxWidthContainer,
} = require('@/components/max-width-container')

async function Video({ searchParams }) {
    const pageNumber = await searchParams
    const videos = await fetchVideos(pageNumber.page)
    // console.log(videos.next_page_url)
    return (
        <MaxWidthContainer>
            <div>
                {videos &&
                    videos.data.map(video => (
                        <div key={video.id} className="mb-4">
                            <Link href={`/video/${video.slug}`}>
                                <div className="flex gap-2">
                                    <img
                                        className="w-[150px] sm:w-[200px]  aspect-video object-cover rounded"
                                        src={video.thumbnail}
                                        alt="Video Thumbnail"
                                    />
                                    <div className=" w-full ">
                                        <h2 className="font-bold  text-lg line-clamp-2">
                                            {video.title}
                                        </h2>
                                        <p className="line-clamp-2 text-sm">
                                            {video.description}
                                        </p>
                                    </div>
                                </div>
                            </Link>
                        </div>
                    ))}
                <div>
                    <Pagination>
                        <PaginationContent>
                            <PaginationItem>
                                {videos.links.prev ? (
                                    <Link
                                        className="flex gap-1 items-center p-2 rounded"
                                        href={
                                            `/videos?page=` +
                                            videos.links.prev.split('=')[1]
                                        }>
                                        <ChevronLeft size={18} />
                                        <span className="text-sm">
                                            Previous
                                        </span>
                                    </Link>
                                ) : (
                                    <Link
                                        className="flex gap-1 items-center pointer-events-none bg-muted p-2 rounded"
                                        href="#">
                                        <ChevronLeft size={18} />
                                        <span className="text-sm">
                                            Previous
                                        </span>
                                    </Link>
                                )}
                            </PaginationItem>
                            <PaginationItem>
                                <PaginationLink href={`/videos?page=1`}>
                                    1
                                </PaginationLink>
                            </PaginationItem>
                            <PaginationItem>
                                <PaginationEllipsis />
                            </PaginationItem>
                            <PaginationItem>
                                {videos.links.next ? (
                                    <Link
                                        className="flex gap-1 items-center p-2 rounded"
                                        href={
                                            `/videos?page=` +
                                            videos.links.next.split('=')[1]
                                        }>
                                        <span className="text-sm">Next</span>
                                        <ChevronRight size={18} />
                                    </Link>
                                ) : (
                                    <Link
                                        className="flex gap-1 items-center pointer-events-none bg-muted p-2 rounded"
                                        href="#">
                                        <span className="text-sm">Next</span>
                                        <ChevronRight size={18} />
                                    </Link>
                                )}
                            </PaginationItem>
                        </PaginationContent>
                    </Pagination>
                </div>
            </div>
            <div className="relative w-full sm:max-w-xs">
                <div className=" grid place-content-center w-full bg-emerald-400 text-black aspect-square p-2">
                    <p>Advertisment</p>
                </div>

                {/* <div className="mt-4 space-y-4 sticky top-2">
                    <Heading title={'जरूर पढ़ें'} />
                    <div className="grid  grid-cols-1 gap-1 ">
                        {mustRead &&
                            mustRead.data.map(post => (
                                <div className="" key={post.id}>
                                    <PostBlock post={post} />
                                </div>
                            ))}
                    </div>
                </div> */}
            </div>
        </MaxWidthContainer>
    )
}

export default Video
