import { fetchAds, fetchCategoryPosts, fetchPosts } from '@/actions/fetchPost'

import Heading from '@/components/Heading'

import PostBlock from '@/components/PostBlock'
import BigPostBlock from '@/components/BigPostBlock'
import HomeSlider from '@/components/HomeSlider'
import { APP_URL_STORAGE } from '@/constant/apiEndpoints'
import Videos from '@/components/Videos'

export const metadata = {
    title: 'Janpad News Times',
}
export const revalidate = 300

const Home = async () => {
    const posts = await fetchPosts()

    const ads = await fetchAds()
    const uttarpradeshNews = await fetchCategoryPosts('uttarpradesh', 1)
    const crimeNews = await fetchCategoryPosts('crime', 1)
    const politicsNews = await fetchCategoryPosts('politics', 1)
    const sportsNews = await fetchCategoryPosts('sports', 1)
    const religiousNews = await fetchCategoryPosts('religion', 1)
    const businessNews = await fetchCategoryPosts('business', 1)
    const mustRead = await fetchCategoryPosts('must-read', 1)

    return (
        <div>
            <div className="flex  px-2 sm:px-32 justify-center items-center w-full">
                {ads && <HomeSlider slides={ads.slider1} />}
            </div>
            <div className=" px-2 sm:px-32 mt-2 flex gap-6 flex-col sm:flex-row">
                <div className="max-w-5xl w-full flex flex-col gap-4">
                    <Heading title={'हिंदी न्यूज़'} />
                    <div className="grid  lg:grid-cols-2 grid-cols-1 gap-1 lg:grid-rows-5">
                        {posts &&
                            posts.data.map((post, index) =>
                                index === 0 ? (
                                    <BigPostBlock post={post} key={post.id} />
                                ) : (
                                    <div className="" key={post.id}>
                                        <PostBlock post={post} />
                                    </div>
                                ),
                            )}
                    </div>

                    <div className="w-full flex flex-col gap-2">
                        <Heading title={'विडियो'} />
                        <Videos />
                    </div>
                    {uttarpradeshNews && (
                        <>
                            <Heading title={'उत्तर प्रदेश'} />
                            <div className="grid lg:grid-cols-2 grid-cols-1 gap-1 lg:grid-rows-5">
                                {uttarpradeshNews.data.map((post, index) =>
                                    index === 0 ? (
                                        <BigPostBlock
                                            post={post}
                                            key={post.id}
                                        />
                                    ) : (
                                        <div className="" key={post.id}>
                                            <PostBlock post={post} />
                                        </div>
                                    ),
                                )}
                            </div>
                        </>
                    )}
                    <Heading title={'क्राइम'} />
                    <div className="grid lg:grid-cols-2 grid-cols-1 gap-1 lg:grid-rows-5">
                        {crimeNews &&
                            crimeNews?.data?.map((post, index) =>
                                index === 0 ? (
                                    <BigPostBlock post={post} key={post.id} />
                                ) : (
                                    <div className="" key={post.id}>
                                        <PostBlock post={post} />
                                    </div>
                                ),
                            )}
                    </div>
                    <Heading title={'राजनीती'} />
                    <div className="grid lg:grid-cols-2 grid-cols-1 gap-1 lg:grid-rows-5">
                        {politicsNews &&
                            politicsNews.data.map((post, index) =>
                                index === 0 ? (
                                    <BigPostBlock post={post} key={post.id} />
                                ) : (
                                    <div className="" key={post.id}>
                                        <PostBlock post={post} />
                                    </div>
                                ),
                            )}
                    </div>
                    <Heading title={'खेल '} />
                    <div className="grid lg:grid-cols-2 grid-cols-1 gap-1 lg:grid-rows-5">
                        {sportsNews &&
                            sportsNews.data.map((post, index) =>
                                index === 0 ? (
                                    <BigPostBlock post={post} key={post.id} />
                                ) : (
                                    <div className="" key={post.id}>
                                        <PostBlock post={post} />
                                    </div>
                                ),
                            )}
                    </div>
                    <Heading title={'व्यापर '} />
                    <div className="grid lg:grid-cols-2 grid-cols-1 gap-1 lg:grid-rows-5">
                        {businessNews &&
                            businessNews.data.map((post, index) =>
                                index === 0 ? (
                                    <BigPostBlock post={post} key={post.id} />
                                ) : (
                                    <div className="" key={post.id}>
                                        <PostBlock post={post} />
                                    </div>
                                ),
                            )}
                    </div>
                    <Heading title={'धर्मं'} />
                    <div className="grid lg:grid-cols-2 grid-cols-1 gap-1 lg:grid-rows-5">
                        {religiousNews &&
                            religiousNews.data.map((post, index) =>
                                index === 0 ? (
                                    <BigPostBlock post={post} key={post.id} />
                                ) : (
                                    <div className="" key={post.id}>
                                        <PostBlock post={post} />
                                    </div>
                                ),
                            )}
                    </div>
                </div>
                <div className="relative w-full sm:max-w-xs">
                    <div className=" grid place-content-center w-full  text-black aspect-square p-2">
                        <p className="text-xs text-end">Advertisment</p>
                        {ads?.square_ad_1 && (
                            <img
                                src={`${APP_URL_STORAGE}/${ads.square_ad_1}`}
                                alt="ads"
                                className="w-full h-full"
                            />
                        )}
                    </div>

                    <div className="mt-4 space-y-4 sm:sticky sm:top-[-650px]">
                        <Heading title={'क्रिकेट'} />
                        <iframe
                            src="https://widget.crictimes.org/"
                            className="w-full h-[400px] min-h-[400px]"></iframe>

                        <Heading title={'राशिफल'} />
                        <div className="my-2">
                            <iframe
                                src="https://piushtrivedi.neocities.org/hindi_astrology_google_gadget_part_1_updated_html2.html"
                                height="250"
                                width="300"></iframe>
                        </div>
                        <Heading title={'जरूर पढ़ें'} />
                        <div className="grid  grid-cols-1 gap-1 ">
                            {mustRead &&
                                mustRead.data.map(post => (
                                    <div key={post.id}>
                                        <PostBlock post={post} />
                                    </div>
                                ))}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    )
}

export default Home
