import { Nunito } from 'next/font/google'
import '@/app/global.css'
import 'swiper/css'
import Header from '@/components/Header'
import Footer from '@/components/Footer'
import PrelineScript from '@/components/PrelineScript'

import AdHeader from '@/components/AdHeader'
import Webpushr from '@/components/WebPusher'
import { GoogleAnalytics } from '@next/third-parties/google'
import Script from 'next/script'
import LiveClock from '@/components/LiveClock'
import OneSignalComponent from '@/components/OneSignal'

const nunitoFont = Nunito({
    subsets: ['latin'],
    display: 'swap',
})

const RootLayout = ({ children }) => {
    return (
        <html lang="en" className={nunitoFont.className}>
            <body id="body" className="antialiased">
                <Script
                    async
                    src={`https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=${process.env.NEXT_PUBLIC_GOOGLE_ADS_CLIENT_ID}`}
                    strategy="lazyOnload"
                    crossOrigin="anonymous"></Script>

                <div className="sticky top-0  z-10">
                    <Header />
                </div>

                <AdHeader />

                <main>{children}</main>
                <Footer />
            </body>
            <GoogleAnalytics gaId="G-ZK7YNR2DSY" />
            <OneSignalComponent />

            {/* <Webpushr /> */}
            <PrelineScript />
        </html>
    )
}

export const metadata = {
    title: 'Janpad news times | Uttarpradesh janpad news in Hindi News | Chandauli ',
}

export default RootLayout
