import { API_URL, POST_URL, VIDEO_URL } from '@/constant/apiEndpoints'

export async function fetchPost(slug) {
    try {
        const response = await fetch(`${API_URL}${POST_URL}/${slug}`, {
            headers: { Accept: 'application/json' },
        })
        const posts = await response.json()

        return posts
    } catch (error) {
        console.error('Error fetching post:', error)
    }
}
export async function fetchPosts() {
    try {
        const response = await fetch(`${API_URL}${POST_URL}`, {
            headers: { Accept: 'application/json' },
        })
        const posts = await response.json()

        return posts
    } catch (error) {
        console.error('Error fetching posts:', error)
    }
}

export async function fetchVideos(page = 1) {
    try {
        const response = await fetch(`${API_URL}${VIDEO_URL}?page=${page}`, {
            headers: { Accept: 'application/json' },
        })
        const posts = await response.json()

        return posts
    } catch (error) {
        console.error('Error fetching posts:', error)
    }
}
export async function fetchVideo(slug) {
    try {
        const response = await fetch(`${API_URL}/video/${slug}`, {
            headers: { Accept: 'application/json' },
        })
        const posts = await response.json()

        return posts
    } catch (error) {
        console.error('Error fetching posts:', error)
    }
}
export async function fetchAds() {
    try {
        const response = await fetch(`${API_URL}/ads`, {
            headers: { Accept: 'application/json' },
        })
        const ads = await response.json()
        // console.log(ads)

        return ads
    } catch (error) {
        console.error('Error fetching ads:', error)
    }
}
export async function fetchCategoryList(categorySlug) {
    try {
        const response = await fetch(
            `${API_URL}/categorylist/${categorySlug}`,
            {
                headers: { Accept: 'application/json' },
            },
        )
        const category = await response.json()
        // console.log({ category })

        return category
    } catch (error) {
        console.error('Error fetching category list:', error)
    }
}
export async function fetchCategoryPosts(categorySlug, page = 1) {
    try {
        const response = await fetch(
            `${API_URL}/${categorySlug}/posts?page=${page}`,
            {
                headers: { Accept: 'application/json' },
                next: { tags: categorySlug, revalidate: 300 },
            },
        )
        const data = await response.json()
        return data
    } catch (error) {
        console.error('Error fetching category posts:', error)
    }
}
export async function fetchCategories() {
    try {
        const response = await fetch(`${API_URL}/categories`, {
            headers: { Accept: 'application/json' },
        })
        const data = await response.json()

        return data
    } catch (error) {
        console.error('Error fetching category posts:', error)
    }
}
