import { API_URL, MENU_URL } from '@/constant/apiEndpoints'

export async function fetchMenu() {
    try {
        const response = await fetch(`${API_URL}/${MENU_URL}`, {
            headers: { Accept: 'application/json' },
        })
        const menus = await response.json()
        return menus
    } catch (error) {
        console.error(error)
    }
}
export async function fetchBrand() {
    try {
        const response = await fetch(`${API_URL}/brand`, {
            headers: { Accept: 'application/json' },
        })
        const menus = await response.json()

        return menus
    } catch (error) {
        console.error(error)
    }
}
export async function fetchSocial() {
    try {
        const response = await fetch(`${API_URL}/social`, {
            headers: { Accept: 'application/json' },
            next: { revalidate: 600 },
        })
        const social = await response.json()

        return social
    } catch (error) {
        console.error(error)
    }
}
