import axios from 'axios'
import { faker } from '@faker-js/faker'

// Google Analytics 4 Measurement ID (G-XXXXXXXXXX)
const measurementId = 'G-MPCN0S35NM' // Replace with your GA4 Measurement ID

// Google Analytics 4 API Secret (generated in GA4 console)
const apiSecret = 'EasU2ZBSSqmTmm06asIVAg' // Replace with your API secret

// Fake headers to simulate location based on IP

// List of some states and cities within India
const indianStates = [
    'Maharashtra',
    'Karnataka',
    'Uttar Pradesh',
    'Tamil Nadu',
    'Gujarat',
    'Delhi',
    'West Bengal',
    'Rajasthan',
    'Kerala',
    'Bihar',
]
const indianCities = {
    Maharashtra: ['Mumbai', 'Pune', 'Nagpur', 'Nashik', 'Thane'],
    Karnataka: ['Bangalore', 'Mysore', 'Mangalore', 'Hubli', 'Belgaum'],
    'Uttar Pradesh': ['Lucknow', 'Kanpur', 'Varanasi', 'Agra', 'Allahabad'],
    'Tamil Nadu': [
        'Chennai',
        'Coimbatore',
        'Madurai',
        'Salem',
        'Tiruchirappalli',
    ],
    Gujarat: ['Ahmedabad', 'Surat', 'Vadodara', 'Rajkot', 'Bhavnagar'],
    Delhi: ['New Delhi'],
    'West Bengal': ['Kolkata', 'Siliguri', 'Durgapur', 'Asansol', 'Howrah'],
    Rajasthan: ['Jaipur', 'Udaipur', 'Jodhpur', 'Kota', 'Ajmer'],
    Kerala: [
        'Thiruvananthapuram',
        'Kochi',
        'Kozhikode',
        'Kottayam',
        'Thrissur',
    ],
    Bihar: ['Patna', 'Gaya', 'Bhagalpur', 'Muzaffarpur', 'Munger'],
}

// Function to generate random location data
function generateLocationData() {
    const randomState = faker.helpers.arrayElement(indianStates)
    const randomCity = faker.helpers.arrayElement(indianCities[randomState])

    return {
        country: 'India',
        state: randomState,
        city: randomCity,
    }
}

// Function to simulate a pageview to Google Analytics with user session
async function sendPageView(clientId) {
    // Generate random location data
    const locationData = generateLocationData()

    const headers = {
        'X-Forwarded-For': faker.internet.ip(), // Fake IP address
        'X-Country': locationData.country, // Custom header for country
        'X-Region': locationData.state, // Custom header for region
        'X-City': locationData.city, // Custom header for city
        'User-Agent':
            'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36',
    }

    // Generate a random page URL for the bot to visit
    const pageUrl = `/news/${faker.string.uuid()}`
    const pageTitle = faker.lorem.words(3)
    const pageDuration = faker.number.int({ min: 1425, max: 3425 })

    // Build the payload for Google Analytics Measurement Protocol API
    const payload = {
        client_id: clientId, // Unique client ID for the user
        events: [
            {
                name: 'page_view', // GA4 event name for pageviews
                params: {
                    page_location: `https://webmitr.in${pageUrl}`, // Full URL with page path
                    page_title: pageTitle, // Random page title
                    user_country: locationData.country,
                    user_region: locationData.state,
                    user_city: locationData.city,
                },
            },
            {
                name: 'engagement_time', // Custom event for page duration
                params: {
                    engagement_time_msec: pageDuration, // Page duration in milliseconds
                    page_location: `https://webmitr.in${pageUrl}`,
                    page_title: pageTitle,
                },
            },
        ],
    }

    // Send the pageview event to Google Analytics
    try {
        const response = await axios.post(
            `https://www.google-analytics.com/mp/collect?measurement_id=${measurementId}&api_secret=${apiSecret}`,
            payload,
            { headers: headers }, // Include custom headers in the request
        )
        console.log(`Pageview sent for ${pageUrl} from ${locationData.city}`)
    } catch (error) {
        console.error('Error sending pageview:', error)
    }
}

// Function to simulate multiple active users with unique client IDs
async function simulateTraffic(numUsers, numPageViewsPerUser) {
    // Create an array of active users (unique client IDs)
    const users = Array.from({ length: numUsers }, () => faker.string.uuid()) // Generate unique client IDs

    // Loop over each user and simulate multiple pageviews per user
    for (let userIndex = 0; userIndex < numUsers; userIndex++) {
        const clientId = users[userIndex]

        // Simulate multiple pageviews for this user
        for (let pageIndex = 0; pageIndex < numPageViewsPerUser; pageIndex++) {
            setTimeout(
                async () => {
                    await sendPageView(clientId) // Send pageview for this user
                },
                faker.number.int({ min: 1000, max: 3000 }),
            ) // Random delay (1-3 seconds between pageviews for the same user)
        }
    }
}

// Simulate traffic: 5 users with 10 pageviews each (for testing)
simulateTraffic(40, 5)
