import axios from 'axios'
import { faker } from '@faker-js/faker'

// Google Analytics 4 Measurement ID (G-XXXXXXXXXX)
const measurementId = 'G-MPCN0S35NM' // Replace with your GA4 Measurement ID

// Google Analytics 4 API Secret (generated in GA4 console)
const apiSecret = 'EasU2ZBSSqmTmm06asIVAg' // Replace with your API secret

// Function to generate random location data
function generateLocationData() {
    return {
        country: faker.location.country(),
        region: faker.location.state(),
        city: faker.location.city(),
    }
}

// Function to simulate a pageview to Google Analytics
async function sendPageView() {
    // Generate random location data
    const locationData = generateLocationData()

    // Generate a random page URL for the bot to visit
    const pageUrl = `/page/${faker.string.uuid()}`

    // Build the payload for the Google Analytics Measurement Protocol API
    const payload = {
        client_id: faker.string.uuid(), // Random client ID (unique user identifier)
        events: [
            {
                name: 'page_view', // GA4 event name for pageviews
                params: {
                    page_location: `https://webmitr.in${pageUrl}`, // Full URL with page path
                    page_title: faker.lorem.words(3), // Random page title
                    country: locationData.country,
                    region: locationData.region,
                    city: locationData.city,
                },
            },
        ],
    }

    // Send the pageview event to Google Analytics
    try {
        const response = await axios.post(
            `https://www.google-analytics.com/mp/collect?measurement_id=${measurementId}&api_secret=${apiSecret}`,
            payload,
        )
        console.log(
            `Pageview sent for ${pageUrl} from ${locationData.city}, ${locationData.region}, ${locationData.country}`,
        )
    } catch (error) {
        console.error('Error sending pageview:', error)
    }
}

// Simulate 10 pageviews in random intervals (e.g., every 2 to 5 seconds)
function simulateTraffic() {
    const numPageViews = 10
    let count = 0

    const interval = setInterval(
        () => {
            sendPageView()
            count++

            if (count >= numPageViews) {
                clearInterval(interval)
            }
        },
        faker.number.int({ min: 2000, max: 5000 }),
    ) // Random delay between 2 to 5 seconds
}

// Start the traffic simulation
simulateTraffic()
